/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.active.burst_arts;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import java.util.function.Consumer;
import net.forixaim.battle_arts.core_assets.animations.BattleAnimations;
import net.forixaim.battle_arts.core_assets.capabilities.styles.ImperatriceLumiereStyles;
import net.forixaim.battle_arts.core_assets.skills.BattleArtsDataKeys;
import net.forixaim.battle_arts.core_assets.skills.active.burst_arts.BurstArt;
import net.forixaim.battle_arts.initialization.registry.SkillRegistry;
import net.forixaim.battle_arts.initialization.registry.SoundRegistry;
import net.forixaim.bs_api.battle_arts_skills.BattleArtsSkillSlots;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.SkillExecuteEvent;

public class FlareBurst
extends BurstArt {
    private static final UUID EVENT_UUID = UUID.fromString("1f198bcc-af51-45ae-a5f0-78496ec47408");
    private static final AnimationProvider<AttackAnimation> FLARE_BURST_ACTIVATE = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_FLARE_BURST;
    private boolean ready = false;
    private final Consumer<SkillExecuteEvent> skillExecuteEvent = event -> {};

    public FlareBurst(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.setResource(container.getMaxResource());
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executer) {
        return executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).hasSkill(SkillRegistry.IMPERATRICE_LUMIERE) && executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get()) && (Boolean)executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get()) == false && (Boolean)executer.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get()) == false && this.manaCheck(executer);
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executor, FriendlyByteBuf args) {
        executor.playSound((SoundEvent)SoundRegistry.BURST_ART_READY.get(), 0.0f, 0.0f);
        executor.playAnimationSynchronized(FLARE_BURST_ACTIVATE.get(), 0.0f);
        super.executeOnServer(executor, args);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)container.getExecuter()) == ImperatriceLumiereStyles.IMPERATRICE_SWORD || container.getExecuter().getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch)container.getExecuter()) == ImperatriceLumiereStyles.FORIXAIM_SWORD) && container.getResource() > 0.0f && container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get()) && (Boolean)container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get()) == false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x - 4, (int)y - 4, 36, 36, 0.0f, 0.0f, 1, 1, 1, 1);
        float CD = container.getResource();
        String Cooldown_Time = container.getMaxResource() - CD > 100.0f ? String.format("%.0f", Float.valueOf(container.getMaxResource() - CD)) : String.format("%.1f", Float.valueOf(container.getMaxResource() - CD));
        guiGraphics.drawString(gui.font, Cooldown_Time, x + 4.0f, y + 6.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get()) && ((Boolean)container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get())).booleanValue()) {
            container.setResource(0.0f);
            this.ready = false;
        }
        if (container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.HEAT.get()) && !(((Float)container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.HEAT.get())).floatValue() >= 200.0f) && ((Boolean)container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get())).booleanValue() && !container.getExecuter().isLogicalClient()) {
            container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get(), (Object)false, (ServerPlayer)container.getExecuter().getOriginal());
        }
    }

    public void onReset(SkillContainer container) {
        super.onReset(container);
    }

    public float getCooldownRegenPerSecond(PlayerPatch<?> player) {
        float multiplier = 1.0f;
        if (((Player)player.getOriginal()).m_6060_()) {
            multiplier += 0.5f;
        } else if (((Player)player.getOriginal()).m_20077_()) {
            multiplier += 1.0f;
        }
        if (((Player)player.getOriginal()).m_9236_().m_46472_() == Level.f_46429_) {
            multiplier += 0.5f;
        }
        return 1.0f * multiplier;
    }
}

